"""
Slightly modified DEFCON CTF POW script https://github.com/o-o-overflow/chall-adamtune/blob/master/powserver.py
Licensed under GNU GPL3 https://github.com/o-o-overflow/chall-adamtune/blob/master/LICENSE
"""

import struct
import hashlib
import string
import secrets

def pow_hash(challenge, solution):
    return hashlib.sha256(challenge.encode('ascii') + struct.pack('<Q', solution)).hexdigest()

def check_pow(challenge, n, solution):
    h = pow_hash(challenge, solution)
    return (int(h, 16) % (2**n)) == 0

def random_string(length=10):
    characters = string.ascii_letters + string.digits
    return ''.join(secrets.choice(characters) for _ in range(length))
